uniform sampler2D 	depthTex;
varying vec2 		texcoord;
varying vec2		VPOS;
varying vec4		curpos;
uniform float		vScale;

uniform mat4		prevViewProjMatrix;
uniform mat4		eyeToWorld;

////////////////////////////

void main()
{
	// compute cur eye position
	vec4 pos;	
	pos.z = texture2D(depthTex,texcoord.st).r;
	pos.xy=VPOS*-pos.z;
	pos.w=1.0;
	
	// compute cur view pos
	vec4 wpos=eyeToWorld*pos;
		
	// compute prev view pos
	vec4 prev=prevViewProjMatrix*wpos;
	
	// compute velocity
	vec2 vel=(curpos.xy/curpos.w-(prev.xy/prev.w))*vScale;
	
	// output
	//gl_FragColor.rg=vec2(0.0);
	gl_FragColor.ba=(vel*vec2(0.5))+vec2(0.5);
}
